
--- SIMTAGFUNCTIONS ----------------------------------------------------

--- TODO: Check that gradient is being used
--- TODO: Filter trailer events in same way as vehicle events

fn DSIMFUNreadBinString FUNfileStream =
(
  fseek FUNfileStream 4 #seek_cur                                  -- required before reading a string
  readString FUNfileStream                                         -- return value
)

fn DSIMFUNreadElementHeader FUNfileStream =
(
  local LOCelemType       = DSIMFUNreadBinString FUNfileStream       --
  local LOCfileOffset     = readLongLong FUNfileStream               --
  local LOCfileStop       = ftell FUNfileStream                      --

  local LOCarray = #(LOCelemType, LOCfileOffset, LOCfileStop)

  LOCarray                                                           -- return value
)

fn DSIMFUNreadElemQParGlobals FUNfileStream FUNfileOffset FUNfileStop =
(
  fseek FUNfileStream FUNfileOffset #seek_set                        -- move to position in file to pick up element content
  readLongLong FUNfileStream                                         -- NOTE: EVERY element starts with an int (or long for "D") that holds the chunk size (of the element and all its sub-elements combined). You don't need this value unless you start sequentially stream-reading which would defeat the purpose of the index at this point). I decided to keep the field in there because it might be useful in the future. So you can skip over the first INT (or LONG) after jumping to the data position for an element.

  local LOCprjName    = DSIMFUNreadBinString FUNfileStream           -- QParamics Project Name
  local LOCprjDesc    = DSIMFUNreadBinString FUNfileStream           -- QParamics Project Description
  local LOCunitDist   = readByte  FUNfileStream                      -- QParamics Display Distance Unit (0 = metres, 1 = feet, 2 = miles, 3 = kilometres)
  local LOCunitSpeed  = readByte  FUNfileStream                      -- QParamics Display Speed Unit (0 = mph, 1 = kph)
  local LOCunitWeight = readByte  FUNfileStream                      -- QParamics Display Weight Unit (0 = UK, 1 = US)
  local LOCdmdFactor  = readFloat FUNfileStream                      -- QParamics Demand Factor (global scale to increase of decrease volume of traffic in model)

  if FUNfileStop != 0 then fseek FUNfileStream FUNfileStop #seek_set --

  #(LOCprjName, LOCprjDesc, LOCunitDist, LOCunitSpeed, LOCunitWeight, LOCdmdFactor) -- Return Value
)

fn DSIMFUNreadElemQParInfoSceneTime FUNfileStream FUNfileOffset FUNfileStop =
(
  fseek FUNfileStream FUNfileOffset #seek_set                        -- move to position in file to pick up element content
  readLongLong FUNfileStream                                         -- NOTE: EVERY element starts with an int (or long for "D") that holds the chunk size (of the element and all its sub-elements combined). You don't need this value unless you start sequentially stream-reading which would defeat the purpose of the index at this point). I decided to keep the field in there because it might be useful in the future. So you can skip over the first INT (or LONG) after jumping to the data position for an element.

  local LOCstartTime = readFloat FUNfileStream                       -- time in seconds of global start of animation since zero
  local LOCendTime   = readFloat FUNfileStream                       -- time in seconds of global end of animation since zero
  local LOCstepInt   = readFloat FUNfileStream                       -- Paramics uses the concept of TimeSteps. This number internally is in the range 2-100 and set by the user when they build their model. At each iteration of the simulation the clock moves forward by 1/N seconds where is N is the timestep value. This can be thought of as a frame rate, vehicle positions will be generated at each timestep, the higher the timestep value the smoother the movement of vehicles.

  if FUNfileStop != 0 then fseek FUNfileStream FUNfileStop #seek_set

  #(LOCstartTime, LOCendTime, LOCstepint)                            -- Return Value
)

fn DSIMFUNreadElemQParInfoSceneShift FUNfileStream FUNfileOffset FUNfileStop =
(
  fseek FUNfileStream FUNfileOffset #seek_set                        -- move to position in file to pick up element content
  readLongLong FUNfileStream                                         -- NOTE: EVERY element starts with an int (or long for "D") that holds the chunk size (of the element and all its sub-elements combined). You don't need this value unless you start sequentially stream-reading which would defeat the purpose of the index at this point). I decided to keep the field in there because it might be useful in the future. So you can skip over the first INT (or LONG) after jumping to the data position for an element.

  local LOCshiftX = readLong FUNfileStream                           --
  local LOCshiftY = readLong FUNfileStream                           --
  local LOCshiftZ = readLong FUNfileStream                           --

  if FUNfileStop != 0 then fseek FUNfileStream FUNfileStop #seek_set

  #(LOCshiftX, LOCshiftY, LOCshiftZ)                                 -- Return Value
)

fn DSIMFUNreadElemQParVehicleType FUNfileStream FUNfileOffset FUNfileStop =
(
  fseek FUNfileStream FUNfileOffset #seek_set                        -- move to position in file to pick up element content
  readLongLong FUNfileStream                                         -- NOTE: EVERY element starts with an int (or long for "D") that holds the chunk size (of the element and all its sub-elements combined). You don't need this value unless you start sequentially stream-reading which would defeat the purpose of the index at this point). I decided to keep the field in there because it might be useful in the future. So you can skip over the first INT (or LONG) after jumping to the data position for an element.

  local LOCvTypeID     = readByte FUNfileStream; LOCvTypeID += 1     -- ID (AutoIndex)
  local LOCvTypeName   = DSIMFUNreadBinString FUNfileStream          -- VehicleType Name
  local LOCtrailerCnt  = readByte FUNfileStream                      -- TrailerCount
  local LOCcolorR      = readByte FUNfileStream #unsigned            -- ColorR
  local LOCcolorG      = readByte FUNfileStream #unsigned            -- ColorG
  local LOCcolorB      = readByte FUNfileStream #unsigned            -- ColorB
  local LOCisBus       = readByte FUNfileStream                      -- IsBus
  local LOCcapacity    = readLong FUNfileStream                      -- Capacity
  local LOCentryDoors  = readByte FUNfileStream                      -- EntryDoors
  local LOCexitDoors   = readByte FUNfileStream                      -- ExitDoors
  local LOCwidth       = readFloat FUNfileStream                     -- Width
  local LOClength      = readFloat FUNfileStream                     -- Length
  local LOCheight      = readFloat FUNfileStream                     -- Height
  local LOCweight      = readFloat FUNfileStream                     -- Weight
  local LOCcabLength   = readFloat FUNfileStream                     -- CabLength
  local LOCmeanAge     = readFloat FUNfileStream                     -- MeanAge
  local LOCmaxAccel    = readFloat FUNfileStream                     -- MaxAccel
  local LOCmaxDecel    = readFloat FUNfileStream                     -- MaxDecel
  local LOCtopSpeed    = readFloat FUNfileStream                     -- TopSpeed
  local LOCbhp         = readFloat FUNfileStream                     -- BHP
  local LOCminCrawl    = readFloat FUNfileStream                     -- MinCrawlSpeed
  local LOCfamProp     = readFloat FUNfileStream                     -- FamiliarProp
  local LOCpCus        = readFloat FUNfileStream                     -- Pcus
  local LOChWayFactor  = readFloat FUNfileStream                     -- HeadwayFactor
  local LOCreactFactor = readFloat FUNfileStream                     -- ReactionFactor

  if FUNfileStop != 0 then fseek FUNfileStream FUNfileStop #seek_set

  #(LOCvTypeID, \                                                    -- Return Value
    LOCvTypeName, \
    LOCtrailerCnt, \
    LOCcolorR, \
    LOCcolorG, \
    LOCcolorB, \
    LOCisBus, \
    LOCcapacity, \
    LOCentryDoors, \
    LOCexitDoors, \
    LOCwidth, \
    LOClength, \
    LOCheight, \
    LOCweight, \
    LOCcabLength, \
    LOCmeanAge, \
    LOCmaxAccel, \
    LOCmaxDecel, \
    LOCtopSpeed, \
    LOCbhp, \
    LOCminCrawl, \
    LOCfamProp, \
    LOCpCus, \
    LOChWayFactor, \
    LOCreactFactor \
  )
)

fn DSIMFUNreadElemQParVehicle FUNfileStream FUNfileOffset FUNfileStop =
(
  fseek FUNfileStream FUNfileOffset #seek_set                         -- move to position in file to pick up element content
  readLongLong FUNfileStream                                          -- NOTE: EVERY element starts with an int (or long for "D") that holds the chunk size (of the element and all its sub-elements combined). You don't need this value unless you start sequentially stream-reading which would defeat the purpose of the index at this point). I decided to keep the field in there because it might be useful in the future. So you can skip over the first INT (or LONG) after jumping to the data position for an element.

  local LOCid       = readLong FUNfileStream; LOCid += 1              -- ID AutoIndex
  local LOCvehType  = readByte FUNfileStream; LOCvehType += 1         -- VehicleType ID
  local LOCcolorR   = readByte FUNfileStream #unsigned                -- ColorR
  local LOCcolorG   = readByte FUNfileStream #unsigned                -- ColorG
  local LOCcolorB   = readByte FUNfileStream #unsigned                -- ColorB
  local LOCagress   = readByte FUNfileStream                          -- Agreesion
  local LOCaware    = readByte FUNfileStream                          -- Awareness
  local LOCenterNet = readLong FUNfileStream                          -- TimeEnteredNetwork
  local LOCisFamil  = readByte FUNfileStream                          -- IsFamiliar
  local LOCsourZone = DSIMFUNreadBinString FUNfileStream              -- Source Zone
  local LOCdestZone = DSIMFUNreadBinString FUNfileStream              -- Destination Zone
  local LOCpeturb   = readFloat FUNfileStream                         -- Peturbation Value
  local LOCevCnt    = readLong FUNfileStream                          -- Number of Events
  local LOCevOffset = ftell FUNfileStream                             -- Identify Offset to where Events Chunk Starts

  if FUNfileStop != 0 then fseek FUNfileStream FUNfileStop #seek_set

  #( \                                                                -- return value
    LOCid, \
    LOCvehType, \
    LOCcolorR, \
    LOCcolorG, \
    LOCcolorB, \
    LOCagress, \
    LOCaware, \
    LOCenterNet, \
    LOCisFamil, \
    LOCsourZone, \
    LOCdestZone, \
    LOCpeturb, \
    LOCevCnt, \
    LOCevOffset \
  )
)

fn DSIMFUNreadElemQParVehicleEvent3D FUNfileStream =
(
  local LOCtStamp    = readFloat FUNfileStream                       -- TimeStamp
  local LOCbearing   = readFloat FUNfileStream                       -- Bearing
  local LOCx         = readFloat FUNfileStream                       -- X
  local LOCy         = readFloat FUNfileStream                       -- Y
  local LOCz         = readFloat FUNfileStream                       -- Z
  local LOCgradient  = readFloat FUNfileStream                       -- Gradient
  local LOCspeed     = readFloat FUNfileStream                       -- Speed
  local LOCbrake     = readByte FUNfileStream                        -- IsBraking
  local LOCleftInd   = readByte FUNfileStream                        -- LeftIndicator
  local LOCrightInd  = readByte FUNfileStream                        -- RightIndicator
  local LOCisAccel   = readByte FUNfileStream                        -- IsAccelerating
  local LOCisStopped = readByte FUNfileStream                        -- IsStopped
  local LOCinConj    = readByte FUNfileStream                        -- InConjestion
  local LOCinAcci    = readByte FUNfileStream                        -- InAccident
  local LOCinWrong   = readByte FUNfileStream                        -- InWrongLane
  local LOCwrongDiv  = readByte FUNfileStream                        -- WrongLaneDiversion
  local LOConRound   = readByte FUNfileStream                        -- OnRoundabout
  local LOCinsJunc   = readByte FUNfileStream                        -- InsideJunction
  local LOCcurrLink  = DSIMFUNreadBinString FUNfileStream            -- CurrentLink
  local LOCoccupancy = readLong FUNfileStream                        -- Occupancy
  local LOCcurrLane  = readLong FUNfileStream                        -- CurrentLane

  #( \                                                                -- return value
    LOCtStamp, \
    LOCbearing, \
    LOCx, \
    LOCy, \
    LOCz, \
    LOCgradient, \
    LOCspeed, \
    LOCbrake, \
    LOCleftInd, \
    LOCrightInd, \
    LOCisAccel, \
    LOCisStopped, \
    LOCinConj, \
    LOCinAcci, \
    LOCinWrong, \
    LOCwrongDiv, \
    LOConRound, \
    LOCinsJunc, \
    LOCcurrLink, \
    LOCoccupancy, \
    LOCcurrLane \
  )
)

fn DSIMFUNreadElemQParVehicleEvent2D FUNfileStream =
(
  local LOCtStamp    = readFloat FUNfileStream                       -- TimeStamp
  local LOCbearing   = readFloat FUNfileStream                       -- Bearing
  local LOCx         = readFloat FUNfileStream                       -- X
  local LOCy         = readFloat FUNfileStream                       -- Y
  local LOCspeed     = readFloat FUNfileStream                       -- Speed
  local LOCbrake     = readByte FUNfileStream                        -- IsBraking
  local LOCleftInd   = readByte FUNfileStream                        -- LeftIndicator
  local LOCrightInd  = readByte FUNfileStream                        -- RightIndicator
  local LOCisAccel   = readByte FUNfileStream                        -- IsAccelerating
  local LOCisStopped = readByte FUNfileStream                        -- IsStopped
  local LOCinConj    = readByte FUNfileStream                        -- InConjestion
  local LOCinAcci    = readByte FUNfileStream                        -- InAccident
  local LOCinWrong   = readByte FUNfileStream                        -- InWrongLane
  local LOCwrongDiv  = readByte FUNfileStream                        -- WrongLaneDiversion
  local LOConRound   = readByte FUNfileStream                        -- OnRoundabout
  local LOCinsJunc   = readByte FUNfileStream                        -- InsideJunction
  local LOCcurrLink  = DSIMFUNreadBinString FUNfileStream            -- CurrentLink
  local LOCoccupancy = readLong FUNfileStream                        -- Occupancy
  local LOCcurrLane  = readLong FUNfileStream                        -- CurrentLane

  #( \                                                                -- return value
    LOCtStamp, \
    LOCbearing, \
    LOCx, \
    LOCy, \
    LOCspeed, \
    LOCbrake, \
    LOCleftInd, \
    LOCrightInd, \
    LOCisAccel, \
    LOCisStopped, \
    LOCinConj, \
    LOCinAcci, \
    LOCinWrong, \
    LOCwrongDiv, \
    LOConRound, \
    LOCinsJunc, \
    LOCcurrLink, \
    LOCoccupancy, \
    LOCcurrLane \
  )
)

--- Rollout to display contents of file on screen
rollout DYNqparImport ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCsimFile
  local LOCsimFilePath
  local LOCobjectsAlreadyExist = false
  local LOCpopupMenu           = undefined
  local LOCis3dFile            = false
  local LOCallowDnSelection    = true
  local LOCsimFileInfo         = #()

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNcreateVehicleDummy FUNwidth FUNlength FUNheight FUNwireColor =
  (
    local LOCobj

    --- Set Size of Geometry for Vehicle (Rescale Box Size to convert to current system units)
    local LOCunitMult = 1.0
    case units.SystemType of
    (
      #Inches      : LOCunitMult = 39.3700787
      #Feet        : LOCunitMult = 3.2808399
      #Miles       : LOCunitMult = 0.000621371192
      #Millimeters : LOCunitMult = 1000.0
      #Centimeters : LOCunitMult = 100.0
      #Meters      : LOCunitMult = 1.0
      #Kilometers  : LOCunitMult = 0.001
    )

    --- Create Geometry for Vehicle
    LOCobj                   = box width:(FUNwidth * LOCunitMult) length:(FUNlength * LOCunitMult) height:(FUNheight * LOCunitMult) pos:[1.0,1.5,0.0]
    LOCobj.objectoffsetpos.y = FUNlength / 2.0
    LOCobj.wirecolor         = FUNwireColor

    --- Finish Off
    LOCobj
  )

  fn DYNFUNfindVehicleTypeByID FUNvehicleTypes FUNvehicleTypeID =
  (
    local LOCoutArray = #()
    local LOCproceedSwitch = true

    for i in FUNvehicleTypes do
    (
      if LOCproceedSwitch and i[1] == FUNvehicleTypeID then (LOCoutArray = i; LOCproceedSwitch = false)
    )
    LOCoutArray
  )

  fn DYNFUNmakeDsimImportPopUpMenu FUNlv =
  (
    DYNqparImport.LOCpopupMenu = undefined
    if DYNqparImport.dnListView1.Items.count > 0 then
    (
      local LOCexe = "rcmenu LOCpopupMenu\n"
      LOCexe += "(\n"
      LOCexe += "  menuItem  MNDYNselectAll          checked:false\n"
      LOCexe += "  menuItem  MNDYNselectNone         checked:false\n"
      LOCexe += "  separator MNDYNseparator1\n"
      LOCexe += "  menuItem  MNDYNselectHighAll      checked:false\n"
      LOCexe += "  menuItem  MNDYNselectHighNone     checked:false\n"
      LOCexe += "  separator MNDYNseparator2\n"
      LOCexe += "  subMenu \"" + DYNuiResourcesSubMenus[16] + "\"\n"
      LOCexe += "  (\n"
      LOCexe += "    menuItem  MNDYNselectTypeAll    checked:false\n"
      LOCexe += "    menuItem  MNDYNselectTypeNone   checked:false\n"
      LOCexe += "  )\n"
      LOCexe += "  subMenu \"" + DYNuiResourcesSubMenus[17] + "\"\n"
      LOCexe += "  (\n"
      LOCexe += "    menuItem  MNDYNselectIDAll      checked:false\n"
      LOCexe += "    menuItem  MNDYNselectIDNone     checked:false\n"
      LOCexe += "  )\n"
      LOCexe += "  subMenu \"" + DYNuiResourcesSubMenus[18] + "\"\n"
      LOCexe += "  (\n"
      LOCexe += "    menuItem  MNDYNselectSourceAll  checked:false\n"
      LOCexe += "    menuItem  MNDYNselectSourceNone checked:false\n"
      LOCexe += "  )\n"
      LOCexe += "  subMenu \"" + DYNuiResourcesSubMenus[19] + "\"\n"
      LOCexe += "  (\n"
      LOCexe += "    menuItem  MNDYNselectDestAll    checked:false\n"
      LOCexe += "    menuItem  MNDYNselectDestNone   checked:false\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  on LOCpopupMenu open do\n"
      LOCexe += "  (\n"
      LOCexe += "    MNDYNselectAll.text        = DYNuiResourcesMenus[14]\n"
      LOCexe += "    MNDYNselectNone.text       = DYNuiResourcesMenus[15]\n"
      LOCexe += "    MNDYNselectHighAll.text    = DYNuiResourcesMenus[16]\n"
      LOCexe += "    MNDYNselectHighNone.text   = DYNuiResourcesMenus[17]\n"
      LOCexe += "    MNDYNselectTypeAll.text    = DYNuiResourcesMenus[18]\n"
      LOCexe += "    MNDYNselectTypeNone.text   = DYNuiResourcesMenus[19]\n"
      LOCexe += "    MNDYNselectIDAll.text      = DYNuiResourcesMenus[18]\n"
      LOCexe += "    MNDYNselectIDNone.text     = DYNuiResourcesMenus[19]\n"
      LOCexe += "    MNDYNselectSourceAll.text  = DYNuiResourcesMenus[18]\n"
      LOCexe += "    MNDYNselectSourceNone.text = DYNuiResourcesMenus[19]\n"
      LOCexe += "    MNDYNselectDestAll.text    = DYNuiResourcesMenus[18]\n"
      LOCexe += "    MNDYNselectDestNone.text   = DYNuiResourcesMenus[19]\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNselectAll  picked do (for i = 1 to DYNqparImport.dnListView1.Items.count do (DYNqparImport.dnListView1.Items.item[i-1].checked = true))\n"
      LOCexe += "  on MNDYNselectNone picked do (for i = 1 to DYNqparImport.dnListView1.Items.count do (DYNqparImport.dnListView1.Items.item[i-1].checked = false))\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNselectHighAll  picked do (for i = 1 to DYNqparImport.dnListView1.SelectedItems.count do (DYNqparImport.dnListView1.SelectedItems.item[i-1].checked = true))\n"
      LOCexe += "  on MNDYNselectHighNone picked do (for i = 1 to DYNqparImport.dnListView1.SelectedItems.count do (DYNqparImport.dnListView1.SelectedItems.item[i-1].checked = false))\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNselectTypeAll  picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    local LOCtype = DYNqparImport.dnListView1.selectedItems.item[0].SubItems.item[1].text\n"
      LOCexe += "    for i = 1 to DYNqparImport.dnListView1.Items.count do\n"
      LOCexe += "    (\n"
      LOCexe += "      local LOCcurrentType = DYNqparImport.dnListView1.Items.item[i-1].SubItems.item[1].text\n"
      LOCexe += "      if LOCtype == LOCcurrentType then DYNqparImport.dnListView1.Items.item[i-1].checked = true\n"
      LOCexe += "    )\n"
      LOCexe += "  )\n"
      LOCexe += "  on MNDYNselectTypeNone picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    local LOCtype = DYNqparImport.dnListView1.selectedItems.item[0].SubItems.item[1].text\n"
      LOCexe += "    for i = 1 to DYNqparImport.dnListView1.Items.count do\n"
      LOCexe += "    (\n"
      LOCexe += "      local LOCcurrentType = DYNqparImport.dnListView1.Items.item[i-1].SubItems.item[1].text\n"
      LOCexe += "      if LOCtype == LOCcurrentType then DYNqparImport.dnListView1.Items.item[i-1].checked = false\n"
      LOCexe += "    )\n"
      LOCexe += "  )\n"
      LOCexe += "  on MNDYNselectIDAll  picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    local LOCtype = DYNqparImport.dnListView1.selectedItems.item[0].SubItems.item[2].text\n"
      LOCexe += "    for i = 1 to DYNqparImport.dnListView1.Items.count do\n"
      LOCexe += "    (\n"
      LOCexe += "      local LOCcurrentType = DYNqparImport.dnListView1.Items.item[i-1].SubItems.item[2].text\n"
      LOCexe += "      if LOCtype == LOCcurrentType then DYNqparImport.dnListView1.Items.item[i-1].checked = true\n"
      LOCexe += "    )\n"
      LOCexe += "  )\n"
      LOCexe += "  on MNDYNselectIDNone picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    local LOCtype = DYNqparImport.dnListView1.selectedItems.item[0].SubItems.item[2].text\n"
      LOCexe += "    for i = 1 to DYNqparImport.dnListView1.Items.count do\n"
      LOCexe += "    (\n"
      LOCexe += "      local LOCcurrentType = DYNqparImport.dnListView1.Items.item[i-1].SubItems.item[2].text\n"
      LOCexe += "      if LOCtype == LOCcurrentType then DYNqparImport.dnListView1.Items.item[i-1].checked = false\n"
      LOCexe += "    )\n"
      LOCexe += "  )\n"
      LOCexe += "  on MNDYNselectSourceAll  picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    local LOCtype = DYNqparImport.dnListView1.selectedItems.item[0].SubItems.item[6].text\n"
      LOCexe += "    for i = 1 to DYNqparImport.dnListView1.Items.count do\n"
      LOCexe += "    (\n"
      LOCexe += "      local LOCcurrentType = DYNqparImport.dnListView1.Items.item[i-1].SubItems.item[6].text\n"
      LOCexe += "      if LOCtype == LOCcurrentType then DYNqparImport.dnListView1.Items.item[i-1].checked = true\n"
      LOCexe += "    )\n"
      LOCexe += "  )\n"
      LOCexe += "  on MNDYNselectSourceNone picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    local LOCtype = DYNqparImport.dnListView1.selectedItems.item[0].SubItems.item[6].text\n"
      LOCexe += "    for i = 1 to DYNqparImport.dnListView1.Items.count do\n"
      LOCexe += "    (\n"
      LOCexe += "      local LOCcurrentType = DYNqparImport.dnListView1.Items.item[i-1].SubItems.item[6].text\n"
      LOCexe += "      if LOCtype == LOCcurrentType then DYNqparImport.dnListView1.Items.item[i-1].checked = false\n"
      LOCexe += "    )\n"
      LOCexe += "  )\n"
      LOCexe += "  on MNDYNselectDestAll  picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    local LOCtype = DYNqparImport.dnListView1.selectedItems.item[0].SubItems.item[7].text\n"
      LOCexe += "    for i = 1 to DYNqparImport.dnListView1.Items.count do\n"
      LOCexe += "    (\n"
      LOCexe += "      local LOCcurrentType = DYNqparImport.dnListView1.Items.item[i-1].SubItems.item[7].text\n"
      LOCexe += "      if LOCtype == LOCcurrentType then DYNqparImport.dnListView1.Items.item[i-1].checked = true\n"
      LOCexe += "    )\n"
      LOCexe += "  )\n"
      LOCexe += "  on MNDYNselectDestNone picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    local LOCtype = DYNqparImport.dnListView1.selectedItems.item[0].SubItems.item[7].text\n"
      LOCexe += "    for i = 1 to DYNqparImport.dnListView1.Items.count do\n"
      LOCexe += "    (\n"
      LOCexe += "      local LOCcurrentType = DYNqparImport.dnListView1.Items.item[i-1].SubItems.item[7].text\n"
      LOCexe += "      if LOCtype == LOCcurrentType then DYNqparImport.dnListView1.Items.item[i-1].checked = false\n"
      LOCexe += "    )\n"
      LOCexe += "  )\n"
      LOCexe += ")\n"

      DYNqparImport.LOCpopupMenu = Execute LOCexe

      registerRightClickMenu DYNqparImport.LOCpopupMenu
    )
  )


  fn DYNFUNopenSIMfile FUNsimFile =
  (
    local LOCfileFormatFound = false
    local LOCsuccessSwitch   = true

    --- Set Up Function Result Parameters
    local LOCprjName                     = ""
    local LOCprjDesc                     = ""
    local LOCshiftX                      = 0
    local LOCshiftY                      = 0
    local LOCshiftZ                      = 0

    ---Start reading Lines from File
    local LOCfileStream = fOpen FUNsimFile "rbS"

    --- Check File Header/Identifier (i.e. DSIMQPAR, etc)
    local LOCheader = ""
    local LOCbyte = readByte LOCfileStream; LOCheader += LOCbyte as string
    local LOCbyte = readByte LOCfileStream; LOCheader += LOCbyte as string
    local LOCbyte = readByte LOCfileStream; LOCheader += LOCbyte as string
    local LOCbyte = readByte LOCfileStream; LOCheader += LOCbyte as string
    local LOCbyte = readByte LOCfileStream; LOCheader += LOCbyte as string
    local LOCbyte = readByte LOCfileStream; LOCheader += LOCbyte as string
    local LOCbyte = readByte LOCfileStream; LOCheader += LOCbyte as string
    local LOCbyte = readByte LOCfileStream; LOCheader += LOCbyte as string

    if LOCheader == "6883737781806582" then                             -- IS HEADER "DSIMQPAR" ?
    (
      LOCfileFormatFound            = true

      --- Reset Global Arrays for SIM File Content
      DYNsimVehicles          = #()
      DYNsimVehicleTypes      = #()
      DYNsimVehicleTypeCounts = #()
      DYNsimInfoSceneTime     = #()
      DYNsimGlobals           = #()

      ---------- READ REMAINDER OF FILE HEADER --------------
      local LOCversion   = readLong LOCfileStream
      local LOCprecision = readByte LOCfileStream                       -- The precision flag. 0 = single, anything not 0 is double.
      local LOC2d3dFlag  = readByte LOCfileStream                       -- The 2d/3d flag. 0 = 2d, anything not 0 is 3d.
      DYNqparImport.LOCis3dFile = if LOC2d3dFlag == 0 then false else true

      local LOCabsOffset = readLongLong LOCfileStream                   -- The absolute offset to the index. Seek from file-start to this position to end up at the index of the file.
      fseek LOCfileStream LOCabsOffset #seek_set                        -- move to file index at end of file

      --- Cycle Through Elements In File
      local LOCnumElements = readLong LOCfileStream                       -- The number of elements in the root of the 'scene' or 'DB'.

      for i = 1 to LOCnumElements do
      (
        --dnProgress.value = ((i as float) / (DYNsimVehicles.count as float) * 100.0) as integer


        local LOCrootElementData = DSIMFUNreadElementHeader LOCfileStream  -- Read Standard Index Data For Every Root Element

        --- If Element Was a QParamics Globals Element ---
        if LOCrootElementData[1] == "QParamicsGlobals" then
        (
          DYNsimGlobals = DSIMFUNreadElemQparGlobals LOCfileStream LOCrootElementData[2] LOCrootElementData[3]
          LOCprjName = DYNsimGlobals[1]
          LOCprjDesc = DYNsimGlobals[2]
        )

        --- If Element Was a Scene Shift Element  -------------------------------------------------------
        if LOCrootElementData[1] == "QParamicsInfoSceneShift" then
        (
          local LOCelemArray = DSIMFUNreadElemQParInfoSceneShift LOCfileStream LOCrootElementData[2] LOCrootElementData[3]
          LOCshiftX = LOCelemArray[1]
          LOCshiftY = LOCelemArray[2]
          LOCshiftZ = LOCelemArray[3]
        )

        if LOCrootElementData[1] == "QParamicsInfoSceneTime" then
        (
          DYNsimInfoSceneTime = DSIMFUNreadElemQParInfoSceneTime LOCfileStream LOCrootElementData[2] LOCrootElementData[3]
        )

        if LOCrootElementData[1] == "QParamicsVehicleType" then
        (
          local LOCelemArray = DSIMFUNreadElemQParVehicleType LOCfileStream LOCrootElementData[2] LOCrootElementData[3]
          append DYNsimVehicleTypes LOCelemArray
        )

        if LOCrootElementData[1] == "QParamicsVehicle" then
        (
          local LOCelemArray = DSIMFUNreadElemQParVehicle LOCfileStream LOCrootElementData[2] LOCrootElementData[3]
          append LOCelemArray false -- 15: vehicle selected for import
          append DYNsimVehicles LOCelemArray
        )
      )
    )

    --- Calculate The Total Number of Each Type of Vehicle
    DYNsimVehicleTypeCounts.count = DYNsimVehicleTypes.count
    for i = 1 to DYNsimVehicleTypeCounts.count do (DYNsimVehicleTypeCounts[i] = 0)
    for i in DYNsimVehicles do
    (
      for ii = 1 to DYNsimVehicleTypes.count do
      (
        if i[2] == DYNsimVehicleTypes[ii][1] then DYNsimVehicleTypeCounts[ii] = DYNsimVehicleTypeCounts[ii] + 1
      )
    )

    --- Display Error If File Was Not Valid
    if not LOCfileFormatFound then
    (
      messagebox (DYNuiResourcesErrorsWarnings[86]) title:DYNuiResourcesTitlebars[1]
      LOCsuccessSwitch = false
      FUNsimFile = undefined
    )

    fClose LOCfileStream

    DYNqparImport.DDDYNobjectType.enabled      = LOCsuccessSwitch
    DYNqparImport.BUDYNitemAdd.enabled         = LOCsuccessSwitch
    DYNqparImport.BUDYNitemRem.enabled         = LOCsuccessSwitch
    DYNqparImport.EDDYNwildCard.enabled        = LOCsuccessSwitch; DYNqparImport.EDDYNwildCard.text = "*"

    DYNqparImport.LBDYNstepThreshold.enabled   = LOCsuccessSwitch
    DYNqparImport.SPDYNstepThreshold.enabled   = LOCsuccessSwitch
    DYNqparImport.LBDYNshiftTime.enabled       = LOCsuccessSwitch
    DYNqparImport.SPDYNshiftTime.enabled       = LOCsuccessSwitch
    DYNqparImport.LBDYNspeedMultiplier.enabled = LOCsuccessSwitch
    DYNqparImport.SPDYNspeedMultiplier.enabled = LOCsuccessSwitch
    DYNqparImport.LBDYNstartTime.enabled       = LOCsuccessSwitch
    DYNqparImport.SPDYNstartTime.enabled       = LOCsuccessSwitch
    DYNqparImport.SLDYNstartTime.enabled       = LOCsuccessSwitch
    DYNqparImport.LBDYNendTime.enabled         = LOCsuccessSwitch
    DYNqparImport.SPDYNendTime.enabled         = LOCsuccessSwitch
    DYNqparImport.SLDYNendTime.enabled         = LOCsuccessSwitch

    #(FUNsimFile, LOCprjName, LOCprjDesc, LOCshiftX, LOCshiftY, LOCshiftZ)
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  button BUDYNdir                pos:[8,9]     width:155 height:20

  dropdownlist DDDYNobjectType   pos:[170,9]   width:140 enabled:false
  edittext EDDYNwildCard         pos:[312,11]  enabled:false text:"*" width:140
  button BUDYNitemAdd            pos:[454,9]   width:20 height:20 enabled:false iconName:"CivilView/UseWildCard" iconSize:[16,16]
  button BUDYNitemRem            pos:[477,9]   width:20 height:20 enabled:false iconName:"CivilView/DeselectWildCard" iconSize:[16,16]

  groupbox GPDYNgroup01          pos:[610, 28] width:225 height:152
  label LBDYNstartTime           pos:[620, 55] align:#left width:200
  slider SLDYNstartTime          pos:[620, 70] range:[0.0,9999999.0,0.0] type:#float width:140 enabled:false
  spinner SPDYNstartTime         pos:[754, 79] range:[0.0,9999999.0,0.0] type:#float align:#right fieldwidth:60 enabled:false
  label LBDYNendTime             pos:[620,117] align:#left width:200
  slider SLDYNendTime            pos:[620,132] range:[0.0,9999999.0,0.0] type:#float width:140 enabled:false
  spinner SPDYNendTime           pos:[754,141] range:[0.0,9999999.0,0.0] type:#float align:#right fieldwidth:60 enabled:false

  label LBDYNlistView2           pos:[9,275]   width:334

  groupbox GPDYNgroup03          pos:[610,187] width:225 height:70
  label LBDYNstepIncrement       pos:[620,211] align:#left width:135 enabled:false
  dropdownlist DDDYNstepInc ""   pos:[755,208] align:#right width:71 enabled:false items:#("0.1", "0.2", "0.3", "0.4", "0.5", "0.6", "0.7", "0.8", "0.9", "1.0", "2.0")
  label LBDYNstepThreshold       pos:[620,234] align:#left width:135 enabled:false
  spinner SPDYNstepThreshold     pos:[752,233] range:[0,99999,2] type:#integer align:#right fieldwidth:60 enabled:false

  groupbox GPDYNgroup08          pos:[610,264] width:225 height:65
  label LBDYNshiftTime           pos:[620,285] align:#left width:135 enabled:false
  spinner SPDYNshiftTime         pos:[752,284] range:[-9999999.0,9999999.0,0.0] type:#float align:#right fieldwidth:60 enabled:false
  label LBDYNspeedMultiplier     pos:[620,306] align:#left width:135 enabled:false
  spinner SPDYNspeedMultiplier   pos:[752,305] range:[1.0,100.0,1] type:#float align:#right fieldwidth:60 enabled:false

  groupbox GPDYNgroup04          pos:[610,335] width:225 height:87
  label LBDYNshiftX              pos:[620,356] align:#left width:135
  spinner SPDYNshiftX            pos:[752,355] range:[-9999999,9999999,0] type:#integer align:#right fieldwidth:60
  label LBDYNshiftY              pos:[620,377] align:#left width:135
  spinner SPDYNshiftY            pos:[752,376] range:[-9999999,9999999,0] type:#integer align:#right fieldwidth:60
  label LBDYNshiftZ              pos:[620,398] align:#left width:135
  spinner SPDYNshiftZ            pos:[752,397] range:[-9999999,9999999,0] type:#float align:#right fieldwidth:60

  button BUDYNhelp width:112     pos:[8,435]   height:22
  button BUDYNokok width:112     pos:[609,435] height:22 enabled:false
  button BUDYNcanc width:112     pos:[722,435] height:22

  label LBDYNstatus              pos:[8,485]   width:826 height:18

  dotNetControl dnListView1 "System.Windows.Forms.ListView"    pos:[8,35]  width:595 height:230 align:#center
  dotNetControl dnListView2 "System.Windows.Forms.ListView"    pos:[8,289] width:595 height:132 align:#center
  dotNetControl dnProgress  "System.Windows.Forms.ProgressBar" pos:[8,465] width:826 height:12

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNqparImport open do
  (
    DYNqparImport.title        = DYNuiRolloutNames[59]

    GPDYNgroup08.text          = DYNuiResourcesGroups[109]
    GPDYNgroup01.text          = DYNuiResourcesGroups[110]
    GPDYNgroup03.text          = DYNuiResourcesGroups[111]
    GPDYNgroup04.text          = DYNuiResourcesGroups[112]

    BUDYNokok.text             = DYNuiResourcesButtons[1]
    BUDYNcanc.text             = DYNuiResourcesButtons[3]
    BUDYNhelp.text             = DYNuiResourcesButtons[5]
    BUDYNdir.text              = DYNuiResourcesButtons[6]

    DDDYNobjectType.items      = #(DYNuiResourcesLabels[480], DYNuiResourcesLabels[481], DYNuiResourcesLabels[482])

    LBDYNstatus.text           = DYNuiResourcesStatusMessages[16]
    LBDYNlistView2.text        = DYNuiResourcesLabels[85]
    LBDYNstepIncrement.text    = DYNuiResourcesLabels[372]
    LBDYNshiftX.text           = DYNuiResourcesLabels[373]
    LBDYNshiftY.text           = DYNuiResourcesLabels[374]
    LBDYNshiftZ.text           = DYNuiResourcesLabels[375]
    LBDYNshiftTime.text        = DYNuiResourcesLabels[376]
    LBDYNspeedMultiplier.text  = DYNuiResourcesLabels[377]
    LBDYNstartTime.text        = DYNuiResourcesLabels[378]
    LBDYNendTime.text          = DYNuiResourcesLabels[379]
    LBDYNstepThreshold.text    = DYNuiResourcesLabels[380]

    LOCsimFilePath             = rootNode.DYNrootNodeStore.string04; if LOCsimFilePath == "" then LOCsimFilePath = (getdir #import) + "\\*.sim"
    LOCsimFile                 = undefined

    --- Read Main INI File Settings
    SPDYNstepThreshold.value   = DYNINIstepThreshold

    --- These properties need only be set and assigned prior to calling ProcessImport()
    SPDYNshiftZ.value          = rootNode.DYNrootNodeStore.float01
    SPDYNshiftX.value          = rootNode.DYNrootNodeStore.int04 as float
    SPDYNshiftY.value          = rootNode.DYNrootNodeStore.int05 as float

    SPDYNshiftTime.value       = 0.0
    SPDYNspeedMultiplier.value = 1

    --- Set Up ListView Displays
    DYNFUNdnListViewStyle dnListView1 true true
    dnListView1.smallimageList   = DYNdnSmImageList
    dnListView1.showItemToolTips = true
    dnListView1.sorting          = DYNdnSortOrderClass.ascending

    dnListView1.Columns.add DYNuiResourcesLvColumns[56]  70
    dnListView1.Columns.add DYNuiResourcesLvColumns[116] 75
    dnListView1.Columns.add DYNuiResourcesLvColumns[117] 65
    dnListView1.Columns.add DYNuiResourcesLvColumns[72]  80
    dnListView1.Columns.add DYNuiResourcesLvColumns[73]  80
    dnListView1.Columns.add DYNuiResourcesLvColumns[71]  57
    dnListView1.Columns.add DYNuiResourcesLvColumns[118] 73
    dnListView1.Columns.add DYNuiResourcesLvColumns[119] 73

    dnListView1.Columns.item[0].TextAlign =  (dotNetClass "System.Windows.Forms.HorizontalAlignment").Left
    dnListView1.Columns.item[1].TextAlign =  (dotNetClass "System.Windows.Forms.HorizontalAlignment").Left
    dnListView1.Columns.item[2].TextAlign =  (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView1.Columns.item[3].TextAlign =  (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView1.Columns.item[4].TextAlign =  (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView1.Columns.item[5].TextAlign =  (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView1.Columns.item[6].TextAlign =  (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView1.Columns.item[7].TextAlign =  (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center

    DYNFUNdnListViewStyle dnListView2 false true
    dnListView2.smallimageList   = DYNdnSmImageList
    dnListView2.showItemToolTips = true
    dnListView2.Columns.add DYNuiResourcesLvColumns[116] 75
    dnListView2.Columns.add DYNuiResourcesLvColumns[120] 33
    dnListView2.Columns.add DYNuiResourcesLvColumns[70]  54
    dnListView2.Columns.add DYNuiResourcesLvColumns[19]  60
    dnListView2.Columns.add DYNuiResourcesLvColumns[121] 70
    dnListView2.Columns.add DYNuiResourcesLvColumns[95]  70
    dnListView2.Columns.add DYNuiResourcesLvColumns[122] 70
    dnListView2.Columns.add DYNuiResourcesLvColumns[123] 70
    dnListView2.Columns.add DYNuiResourcesLvColumns[124] 75
    dnListView2.Columns.add DYNuiResourcesLvColumns[125] 70
    dnListView2.Columns.add DYNuiResourcesLvColumns[126] 70
    dnListView2.Columns.add DYNuiResourcesLvColumns[127] 70
    dnListView2.Columns.add DYNuiResourcesLvColumns[128] 55
    dnListView2.Columns.add DYNuiResourcesLvColumns[129] 50
    dnListView2.Columns.add DYNuiResourcesLvColumns[130] 60
    dnListView2.Columns.add DYNuiResourcesLvColumns[131] 70
    dnListView2.Columns.add DYNuiResourcesLvColumns[132] 70
    dnListView2.Columns.add DYNuiResourcesLvColumns[133] 65
    dnListView2.Columns.add DYNuiResourcesLvColumns[134] 95
    dnListView2.Columns.add DYNuiResourcesLvColumns[135] 85
    dnListView2.Columns.add DYNuiResourcesLvColumns[136] 75
    dnListView2.Columns.add DYNuiResourcesLvColumns[137] 95
    dnListView2.Columns.add DYNuiResourcesLvColumns[138] 90
    dnListView2.Columns.item[0].TextAlign  = (dotNetClass "System.Windows.Forms.HorizontalAlignment").Left
    dnListView2.Columns.item[1].TextAlign  = (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView2.Columns.item[2].TextAlign  = (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView2.Columns.item[3].TextAlign  = (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView2.Columns.item[4].TextAlign  = (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView2.Columns.item[5].TextAlign  = (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView2.Columns.item[6].TextAlign  = (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView2.Columns.item[7].TextAlign  = (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView2.Columns.item[8].TextAlign  = (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView2.Columns.item[9].TextAlign  = (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView2.Columns.item[10].TextAlign = (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView2.Columns.item[11].TextAlign = (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView2.Columns.item[12].TextAlign = (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView2.Columns.item[13].TextAlign = (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView2.Columns.item[14].TextAlign = (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView2.Columns.item[15].TextAlign = (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView2.Columns.item[16].TextAlign = (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView2.Columns.item[17].TextAlign = (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView2.Columns.item[18].TextAlign = (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView2.Columns.item[19].TextAlign = (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView2.Columns.item[20].TextAlign = (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView2.Columns.item[21].TextAlign = (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView2.Columns.item[22].TextAlign = (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center

    --- Check whether any objects already exist in the scene do decide whether a zoom extents is necessary
    LOCobjectsAlreadyExist = if objects.count == 0 then false else true
  )

  on DYNqparImport close do
  (
    DYNsimVehicles          = #()
    DYNsimVehicleTypes      = #()
    DYNsimVehicleTypeCounts = #()
    DYNsimInfoSceneTime     = #()
    DYNsimGlobals           = #()

    dnListView1.Items.clear()
    dnListView2.Items.clear()

    LOCsimFile      = undefined
    LOCsimFilePath  = undefined

    DYNFUNonDialogClose()
  )

  on dnListView1 MouseUp arg do
  (
    if arg.button == DYNdnmouseClass.right then
    (
      DYNFUNmakeDsimImportPopUpMenu dnListView1
      if LOCpopupMenu != undefined then popupMenu LOCpopupMenu
    )
  )

  on dnListView1 ItemChecked arg do
  (
    if LOCallowDnSelection then
    (
      /*  "ItemChecked Event"
        .Item : <System.Windows.Forms.ListViewItem>, read-only
        .Empty : <System.EventArgs>, read-only, static
      */
      if arg.item.tag == "" then
      (
        arg.item.checked = false
      )
      else
      (
        DYNsimVehicles[arg.item.tag as integer][15] = arg.item.checked
      )
    )
  )


  on BUDYNdir pressed do
  (
    local LOCtempSimFile = getOpenFileName caption:DYNuiResourcesTitlebars[9] filename:LOCsimFilePath types:DYNuiResourcesFileTypes[7]


    if LOCtempSimFile != undefined then
    (
      LOCsimFile          = LOCtempSimFile

      DYNqparImport.title = DYNuiRolloutNames[59] + " [" + (filenamefrompath LOCsimFile) + "]"

      LOCsimFileInfo      = DYNFUNopenSIMfile LOCsimFile

      --- Add Vehicle Types to List View 2
      dnListView2.beginUpdate()
      dnListView2.Items.clear()
      local LOClistItemRange          = #()

      for cnt = 1 to DYNsimVehicleTypes.count do
      (
        local i = DYNsimVehicleTypes[cnt]
        local LOCdnListItem       = dotNetObject "System.Windows.Forms.ListViewItem" (i[2] as string)
        LOCdnListItem.tag         = i[1]
        LOCdnListItem.tooltipText = ""
        LOCdnListItem.imageIndex  = 1

        LOCdnListItem.SubItems.add (i[1] as string)
        LOCdnListItem.SubItems.add (DYNsimVehicleTypeCounts[cnt] as string)              -- Count
        LOCdnListItem.SubItems.add ((i[11] as string) + DYNuiResourcesUnitsDistance[2])  -- Width
        LOCdnListItem.SubItems.add ((i[12] as string) + DYNuiResourcesUnitsDistance[2])  -- Length
        LOCdnListItem.SubItems.add ((i[13] as string) + DYNuiResourcesUnitsDistance[2])  -- Height
        LOCdnListItem.SubItems.add ((i[14] as string) + DYNuiResourcesUnitsDistance[9])  -- Weight
        LOCdnListItem.SubItems.add ((i[15] as string) + DYNuiResourcesUnitsDistance[2])  -- Cab Length
        LOCdnListItem.SubItems.add (i[3] as string)                                      -- Trailer Count
        LOCdnListItem.SubItems.add ((i[17] as string) + DYNuiResourcesUnitsDistance[11]) -- MaxAccel
        LOCdnListItem.SubItems.add ((i[18] as string) + DYNuiResourcesUnitsDistance[11]) -- MaxDecel
        LOCdnListItem.SubItems.add ((i[19] as string) + DYNuiResourcesUnitsDistance[10]) -- Top Speed
        LOCdnListItem.SubItems.add (i[20] as string)                                     -- BHP
        LOCdnListItem.SubItems.add (if i[7] == 1 then DYNuiResourcesLabels[149] else DYNuiResourcesLabels[150])  -- isBus
        LOCdnListItem.SubItems.add (i[8] as string)                                      -- Capacity
        LOCdnListItem.SubItems.add (i[9] as string)                                      -- Entry Doors
        LOCdnListItem.SubItems.add (i[10] as string)                                     -- Exit Doors
        LOCdnListItem.SubItems.add (i[16] as string)                                     -- Mean Age
        LOCdnListItem.SubItems.add ((i[21] as string) + DYNuiResourcesUnitsDistance[10]) -- Min Crawl Speed
        LOCdnListItem.SubItems.add (i[22] as string)                                     -- Familiar Prop
        LOCdnListItem.SubItems.add (i[23] as string)                                     -- Pcus
        LOCdnListItem.SubItems.add (i[24] as string)                                     -- Headway Factor
        LOCdnListItem.SubItems.add (i[25] as string)                                     -- Reaction Factor

        /* 01 -- ID (AutoIndex)      10 -- ExitDoors      19 -- TopSpeed
           02 -- VehicleType Name    11 -- Width          20 -- BHP
           03 -- TrailerCount        12 -- Length         21 -- MinCrawlSpeed
           04 -- ColorR              13 -- Height         22 -- FamiliarProp
           05 -- ColorG              14 -- Weight         23 -- Pcus
           06 -- ColorB              15 -- CabLength      24 -- HeadwayFactor
           07 -- IsBus               16 -- MeanAge        25 -- ReactionFactor
           08 -- Capacity            17 -- MaxAccel
           09 -- EntryDoors          18 -- MaxDecel */

        append LOClistItemRange LOCdnListItem
      )

      dnListView2.Items.AddRange LOClistItemRange
      dnListView2.endUpdate()

      --- Add Vehicles To List View 1
      dnListView1.beginUpdate()
      dnListView1.Items.clear()

      local LOClistItemRange          = #() --array to collect the list items
      LOCallowDnSelection = false

      local LOCcnt = 0
      for i in DYNsimVehicles do
      (
        LOCcnt += 1
        local LOCcurVehicleTypeDetails = DYNFUNfindVehicleTypeByID DYNsimVehicleTypes i[2] -- Get Current Vehicle Type Details

        if LOCcurVehicleTypeDetails.count > 0 then
        (
          local LOCdnListItem       = dotNetObject "System.Windows.Forms.ListViewItem" (i[1] as string)
          LOCdnListItem.tag         = LOCcnt as string
          LOCdnListItem.imageIndex  = 1

          local LOCtoolTip          = DYNuiResourcesTooltips[18] + (i[1] as string)
          LOCtoolTip += "\n"
          LOCtoolTip += DYNuiResourcesTooltips[19] + (i[6] as string)
          LOCtoolTip += "\n"
          LOCtoolTip += DYNuiResourcesTooltips[20] + (i[7] as string)
          LOCtoolTip += "\n"
          LOCtoolTip += DYNuiResourcesTooltips[21] + (if i[9] == 1 then DYNuiResourcesLabels[149] else DYNuiResourcesLabels[150])
          LOCtoolTip += "\n"
          LOCtoolTip += DYNuiResourcesTooltips[22] + (i[12] as string)

          LOCdnListItem.tooltipText = LOCtoolTip

          /*  01 -- ID AutoIndex        08 -- TimeEnteredNetwork
              02 -- VehicleType ID      09 -- IsFamiliar
              03 -- ColorR              10 -- Source Zone
              04 -- ColorG              11 -- Destination Zone
              05 -- ColorB              12 -- Peturbation Value
              06 -- Agression           13 -- Number of Events
              07 -- Awareness */

          LOCdnListItem.SubItems.add (LOCcurVehicleTypeDetails[2] as string)
          LOCdnListItem.SubItems.add (LOCcurVehicleTypeDetails[1] as string)
          LOCdnListItem.SubItems.add (((i[8] as float) as string) + "s")
          LOCdnListItem.SubItems.add ((((DYNsimInfoSceneTime[3] * i[13]) + i[8]) as string) + "s")
          LOCdnListItem.SubItems.add (i[13] as string)
          LOCdnListItem.SubItems.add i[10]
          LOCdnListItem.SubItems.add i[11]

          append LOClistItemRange LOCdnListItem
        )
        else
        (
          messagebox (DYNuiResourcesErrorsWarnings[58] + " " + (i[1] as string)) title:DYNuiResourcesTitlebars[1]
        )
      )

      dnListView1.Items.AddRange LOClistItemRange
      dnListView1.endUpdate()
      LOCallowDnSelection = true

      --- If the above worked, derive the basic time resolution of the file (must be called after SetColumnRefs and Setcolumns)
      local LOCbaseTimeRes = DYNsimInfoSceneTime[3]
      local LOCtimeResArray = #(((LOCbaseTimeRes) as string), ((LOCbaseTimeRes * 2) as string), ((LOCbaseTimeRes * 3) as string), ((LOCbaseTimeRes * 4) as string), ((LOCbaseTimeRes * 5) as string), ((LOCbaseTimeRes * 6) as string), ((LOCbaseTimeRes * 7) as string), ((LOCbaseTimeRes * 8) as string), ((LOCbaseTimeRes * 9) as string), ((LOCbaseTimeRes * 10) as string), ((LOCbaseTimeRes * 20) as string),  ((LOCbaseTimeRes * 40) as string))

      LBDYNstepIncrement.enabled   = true
      DDDYNstepInc.items           = LOCtimeResArray
      DDDYNstepInc.selection       = 1
      DDDYNstepInc.enabled         = true

      --- Update other controls in the rollout
      SLDYNstartTime.range         = SPDYNstartTime.range     = [DYNsimInfoSceneTime[1], DYNsimInfoSceneTime[2], DYNsimInfoSceneTime[1]]
      SLDYNendTime.range           = SPDYNendTime.range       = [DYNsimInfoSceneTime[1], DYNsimInfoSceneTime[2], DYNsimInfoSceneTime[2]]
      SPDYNshiftTime.value         = if DYNsimInfoSceneTime[1] == 0.0 then DYNsimInfoSceneTime[1] else -DYNsimInfoSceneTime[1]
      LBDYNstatus.text             = DYNFUNformatValueToString DYNuiResourcesStatusMessages[54] DYNsimVehicles.count
      BUDYNokok.enabled            = true
    )
  )


  on SPDYNstartTime       changed arg do (SLDYNstartTime.value   = arg)
  on SLDYNstartTime       changed arg do (SPDYNstartTime.value   = arg)
  on SPDYNendTime         changed arg do (SLDYNendTime.value     = arg)
  on SLDYNendTime         changed arg do (SPDYNendTime.value     = arg)

  on SPDYNshiftX          changed arg do ( rootNode.DYNrootNodeStore.int04   = arg)
  on SPDYNshiftY          changed arg do ( rootNode.DYNrootNodeStore.int05   = arg)
  on SPDYNshiftZ          changed arg do ( rootNode.DYNrootNodeStore.float01 = arg)

  on BUDYNitemAdd pressed do
  (
    if EDDYNwildCard.text != "" then
    (
      for i = 1 to dnListView1.items.count do
      (
        if DDDYNobjectType.selection == 1 then
        (
          if (matchPattern dnListView1.Items.item[i-1].SubItems.item[1].text pattern:EDDYNwildCard.text ignoreCase:true) then (dnListView1.items.item[i - 1].checked = true)
        )
        if DDDYNobjectType.selection == 2 then
        (
          if (matchPattern dnListView1.Items.item[i-1].SubItems.item[6].text pattern:EDDYNwildCard.text ignoreCase:true) then (dnListView1.items.item[i - 1].checked = true)
        )
        if DDDYNobjectType.selection == 3 then
        (
          if (matchPattern dnListView1.Items.item[i-1].SubItems.item[7].text pattern:EDDYNwildCard.text ignoreCase:true) then (dnListView1.items.item[i - 1].checked = true)
        )
      )
    )
    else
    (
      messagebox DYNuiResourcesErrorsWarnings[18] title:DYNuiResourcesTitlebars[3] beep:false
    )
  )

  on BUDYNitemRem pressed do
  (
    if EDDYNwildCard.text != "" then
    (
      for i = 1 to dnListView1.items.count do
      (
        if DDDYNobjectType.selection == 1 then
        (
          if (matchPattern dnListView1.Items.item[i-1].SubItems.item[1].text pattern:EDDYNwildCard.text ignoreCase:true) then (dnListView1.items.item[i - 1].checked = false)
        )
        if DDDYNobjectType.selection == 2 then
        (
          if (matchPattern dnListView1.Items.item[i-1].SubItems.item[6].text pattern:EDDYNwildCard.text ignoreCase:true) then (dnListView1.items.item[i - 1].checked = false)
        )
        if DDDYNobjectType.selection == 3 then
        (
          if (matchPattern dnListView1.Items.item[i-1].SubItems.item[7].text pattern:EDDYNwildCard.text ignoreCase:true) then (dnListView1.items.item[i - 1].checked = false)
        )
      )
    )
    else
    (
      messagebox DYNuiResourcesErrorsWarnings[18] title:DYNuiResourcesTitlebars[3] beep:false
    )
  )

  on BUDYNokok pressed do
  (
    if SPDYNstartTime.value >= SPDYNendTime.value then
    (
      messagebox DYNuiResourcesErrorsWarnings[54] title:DYNuiResourcesTitlebars[2]
    )
    else
    (
      if dnListView1.checkedItems.count > 0 then
      (


        --- Adjust Animation End Time in Current Max Scene to Accommodate Selected Frames
        local LOCnewEndTime = (((SPDYNendTime.value * frameRate) / SPDYNspeedMultiplier.value) + ((SPDYNshiftTime.value * frameRate) / SPDYNspeedMultiplier.value)) as time

        if LOCnewEndTime > (animationRange.end - animationRange.start) then
        (
          local LOCdisplayString = DYNuiResourcesErrorsWarnings[57]
          LOCdisplayString += "\n\n"
          LOCdisplayString += DYNuiResourcesLabels[386] + " " + ((((animationRange.end - animationRange.start) as integer)/TicksPerFrame) as string) + " " + DYNuiResourcesUnitsTime[5]
          LOCdisplayString += "\n"
          LOCdisplayString += DYNuiResourcesLabels[387] + " " + (((LOCnewEndTime as integer)/TicksPerFrame) as string) + " " + DYNuiResourcesUnitsTime[5]
          LOCdisplayString += "\n\n"
          LOCdisplayString += DYNuiResourcesQueries[32]

          if (DYNFUNdisplayDistQuery DYNuiResourcesTitlebars[3] LOCdisplayString) then
          (
            animationRange = interval animationRange.start (LOCnewEndTime as time)
          )
        )



        --- Create the selected vehicles
        local LOCproceedSwitch = true
        if LOCproceedSwitch then
        (
          DYNFUNremoveCSProllouts()

          actionMan.executeAction 0 "300" -- Ensure that MAX modify panel is NOT open
          DYNFUNloadVSPnodeCallBacks false  -- Enable auto update of Explorer
          (
            with redraw off
            (
              dnProgress.value = 0

              local LOCst = timestamp()

              for i = 1 to DYNsimVehicles.count do -- for each vehicle
              (
                if DYNsimVehicles[i][15] and (DYNsimVehicles[i][13] > SPDYNstepThreshold.value) then -- only import vehicle if it was selected for import in ListView
                (
                  --- Initialise Local Event Variables
                  local LOCleftIndicatorStatus   = 0
                  local LOCrightIndicatorStatus  = 0
                  local LOCisBrakingStatus       = 0
                  local LOCisAcceleratingStatus  = 0
                  local LOCisStoppedStatus       = 0
                  local LOCinConjestionStatus    = 0
                  local LOCinAccidentStatus      = 0
                  local LOCoccupancyStatus       = 0
                  local LOCcurrentLane           = 0
                  local LOCcurrentLink           = ""
                  local LOCcurrentSpeed          = 0.0
                  local LOCactualShiftX          = rootNode.DYNrootNodeStore.int04 - LOCsimFileInfo[4]
                  local LOCactualShiftY          = rootNode.DYNrootNodeStore.int05 - LOCsimFileInfo[5]

                  local LOCveh                   = DYNsimVehicles[i]
                  local LOCcurVehicleTypeDetails = DYNFUNfindVehicleTypeByID DYNsimVehicleTypes LOCveh[2] -- Get Current Vehicle Type Details

                  /* --- Vehicle Attributes ---
                      01 -- ID AutoIndex
                      02 -- VehicleType ID
                      03 -- ColorR
                      04 -- ColorG
                      05 -- ColorB
                      06 -- Agreesion
                      07 -- Awareness
                      08 -- TimeEnteredNetwork
                      09 -- IsFamiliar
                      10 -- Source Zone
                      11 -- Destination Zone
                      12 -- Peturbation Value
                      13 -- Number of Events
                  */

                  local LOCrawCnt2 = 0

                  dnProgress.value = ((i as float) / (DYNsimVehicles.count as float) * 100.0) as integer
                  LBDYNstatus.text = DYNuiResourcesStatusMessages[32] + " : " + LOCcurVehicleTypeDetails[2] + " " + (LOCveh[1] as string)

                  --- Create Dummy Vehicle Geometry
                  local LOCobj = DYNFUNcreateVehicleDummy LOCcurVehicleTypeDetails[11] LOCcurVehicleTypeDetails[15] LOCcurVehicleTypeDetails[13] (color LOCveh[3] LOCveh[4] LOCveh[5])

                  --- Create Position/Rotation/Scale Controllers
                  local LOCctrlP          = LOCobj.pos.controller      = bezier_position()
                  local LOCctrlPkeys      = LOCctrlP.keys

                  local LOCctrlR          = LOCobj.rotation.controller = bezier_rotation()
                  local LOCctrlRkeys      = LOCctrlR.keys

                  local LOCctrlS          = LOCobj.scale.controller    = Civil_View_Traffic_Data_Constraint() -- Create Dummy Scale Controller to hold basic z rotation values (used later for culumative surface tracking), and extended parameters

                  /*
                  Controller:Civil_View_Traffic_Data_Constraint
                    .float01 : float  -- ROTATION QUAT Z         .int03 : integer   -- QP InAccident
                    .float02 : float  -- ROTATION QUAT W         .int04 : integer   -- QP InConjestion
                    .float03 : float  -- ROTATION EULER Z        .int05 : integer   -- QP
                    .float04 : float                             .bool01 : boolean  -- QP IsBraking
                    .float05 : float                             .bool02 : boolean  -- QP LeftIndicator
                    .float06 : float                             .bool03 : boolean  -- QP RightIndicator
                    .float07 : float                             .bool04 : boolean  -- QP IsAccelerating
                    .float08 : float                             .bool05 : boolean  -- QP IsStopped
                    .float09 : float                             .string01 : string -- QP CurrentLink
                    .float10 : float                             .string02 : string
                    .float11 : float                             .string03 : string
                    .float12 : float   -- QP CurrentSpeed        .string04 : string
                    .int01 : integer   -- QP Occupancy           .string05 : string
                    .int02 : integer   -- QP CurrentLane
                  */

                  --- Create Controllers for Civil_View_Traffic_Data_Constraint Extended Parameters
                  local LOCctrlSe        = LOCobj.scale.controller.float03.controller = bezier_float() -- Rotation Z Saved Value
                  local LOCctrlSeKeys    = LOCctrlSe.keys

                  local LOCctrlCuSp      = LOCobj.scale.controller.float12.controller = bezier_float() -- Current Speed
                  local LOCctrlCuSpKeys  = LOCctrlCuSp.keys

                  local LOCctrlIsBr      = LOCobj.scale.controller.bool01.controller  = on_off() -- IsBraking Status
                  local LOCctrlIsBrKeys  = LOCctrlIsBr.keys

                  local LOCctrlIndL      = LOCobj.scale.controller.bool02.controller  = on_off() -- Indicator Left Status
                  local LOCctrlIndLKeys  = LOCctrlIndL.keys

                  local LOCctrlIndR      = LOCobj.scale.controller.bool03.controller  = on_off() -- Indicator Right Status
                  local LOCctrlIndRKeys  = LOCctrlIndR.keys

                  local LOCctrlIsAc      = LOCobj.scale.controller.bool04.controller  = on_off() -- Is Accelerating Status
                  local LOCctrlIsAcKeys  = LOCctrlIsAc.keys

                  local LOCctrlIsSt      = LOCobj.scale.controller.bool05.controller  = on_off() -- IsStopped Status
                  local LOCctrlIsStKeys  = LOCctrlIsSt.keys

                  --- Open Source File to Read Event Data for Current Vehicle
                  local LOCfileStream = fOpen LOCsimFile "rbS"
                  fseek LOCfileStream LOCveh[14] #seek_set                        -- move to file index for events for current vehicle

                  --   Extended Values List
                  -- 3D:07 2D:05 Speed (float)
                  -- 3D:08 2D:06 IsBraking (boolean)
                  -- 3D:09 2D:07 LeftIndicator (boolean)
                  -- 3D:10 2D:08 RightIndicator (boolean)
                  -- 3D:11 2D:09 IsAccelerating (boolean)
                  -- 3D:12 2D:10 IsStopped (boolean)
                  -- 3D:13 2D:11 InConjestion (boolean)
                  -- 3D:14 2D:12 InAccident (boolean)
                  -- 3D:19 2D:17 CurrentLink (string)
                  -- 3D:20 2D:18 Occupancy (integer)
                  -- 3D:21 2D:19 CurrentLane (integer)
                  --   NOT YET USED in DVSP - 3D:15 2D:13 InWrongLane (boolean)
                  --   NOT YET USED in DVSP - 3D:16 2D:14 WrongLaneDiversion (boolean)
                  --   NOT YET USED in DVSP - 3D:17 2D:15 OnRoundabout (boolean)
                  --   NOT YET USED in DVSP - 3D:18 2D:16 InsideJunction (boolean)

                  if DYNqparImport.LOCis3dFile then
                  (
                    local LOCbitArray = #{}; LOCbitArray.count = LOCveh[13]
                    for iii = 1 to LOCveh[13] by DDDYNstepInc.selection do LOCbitArray[iii] = true
                    LOCbitArray[LOCveh[13]] = true

                    for iii = 1 to LOCbitArray.count do
                    (
                      local LOCeventDetails = DSIMFUNreadElemQParVehicleEvent3D LOCfileStream

                      if (LOCbitArray[iii] == true) and LOCeventDetails[1] >= SPDYNstartTime.value and LOCeventDetails[1] <= SPDYNendTime.value then -- Check that we are within range of global start/end time
                      (
                        --- Create New 3ds Max Key Frame
                        local LOCframe    = ((LOCeventDetails[1] * frameRate) / SPDYNspeedMultiplier.value) + ((SPDYNshiftTime.value * frameRate) / SPDYNspeedMultiplier.value)
                        local LOCnewKeyP  = addNewKey LOCctrlPkeys  (LOCframe)
                        local LOCnewKeyR  = addNewKey LOCctrlRkeys  (LOCframe)
                        local LOCnewKeySe = addNewKey LOCctrlSeKeys (LOCframe)

                        --- Insert KeyFrame Values
                        LOCnewKeyP.value      = [LOCactualShiftX, LOCactualShiftY, SPDYNshiftZ.value] + [LOCeventDetails[3], LOCeventDetails[4], LOCeventDetails[5]]
                        LOCnewKeyR.value      = (eulerAngles 0.0 0.0 (LOCeventDetails[2] - 180.0)) as quat
                        LOCnewKeySe.value     = (LOCeventDetails[2] - 180.0)

                        --- Check Status of Extended Values Compared to Last KeyFrame
                        if LOCcurrentSpeed         != LOCeventDetails[07] then (local LOCnewKey = addNewKey LOCctrlCuSpkeys (LOCframe); LOCnewKey.value = LOCeventDetails[07])
                        if LOCisBrakingStatus      != LOCeventDetails[08] then (local LOCnewKey = addNewKey LOCctrlisBrkeys (LOCframe); LOCnewKey.selected = if LOCeventDetails[08] == 1 then true else false)
                        if LOCleftIndicatorStatus  != LOCeventDetails[09] then (local LOCnewKey = addNewKey LOCctrlIndLkeys (LOCframe); LOCnewKey.selected = if LOCeventDetails[09] == 1 then true else false)
                        if LOCrightIndicatorStatus != LOCeventDetails[10] then (local LOCnewKey = addNewKey LOCctrlIndRkeys (LOCframe); LOCnewKey.selected = if LOCeventDetails[10] == 1 then true else false)
                        if LOCisAcceleratingStatus != LOCeventDetails[11] then (local LOCnewKey = addNewKey LOCctrlisAckeys (LOCframe); LOCnewKey.selected = if LOCeventDetails[11] == 1 then true else false)
                        if LOCisStoppedStatus      != LOCeventDetails[12] then (local LOCnewKey = addNewKey LOCctrlisStkeys (LOCframe); LOCnewKey.selected = if LOCeventDetails[12] == 1 then true else false)

                        -- if LOCeventDetails[12]     == 1                   then print ("Vehicle is stopped at " + ((LOCeventDetails[1] as float) as string) + "s.")
                        -- if LOCinConjestionStatus   != LOCeventDetails[13] then print ("Conjestion Status Changed at " + ((LOCeventDetails[1] as float) as string) + "s.")
                        -- if LOCinAccidentStatus     != LOCeventDetails[14] then print ("Accident Status Changed at " + ((LOCeventDetails[1] as float) as string) + "s.")
                        -- if LOCcurrentLink          != LOCeventDetails[19] then print ("Link Status Changed at " + ((LOCeventDetails[1] as float) as string) + "s.")
                        -- if LOCoccupancyStatus      != LOCeventDetails[20] then print ("Occupancy Status Changed at " + ((LOCeventDetails[1] as float) as string) + "s.")
                        -- if LOCcurrentLane          != LOCeventDetails[21] then print ("Lane Status Changed at " + ((LOCeventDetails[1] as float) as string) + "s.")

                        LOCcurrentSpeed         = LOCeventDetails[07]
                        LOCisBrakingStatus      = LOCeventDetails[08]
                        LOCleftIndicatorStatus  = LOCeventDetails[09]
                        LOCrightIndicatorStatus = LOCeventDetails[10]
                        LOCisAcceleratingStatus = LOCeventDetails[11]
                        LOCisStoppedStatus      = LOCeventDetails[12]
                        LOCinConjestionStatus   = LOCeventDetails[13]
                        LOCinAccidentStatus     = LOCeventDetails[14]
                        LOCcurrentLink          = LOCeventDetails[19]
                        LOCoccupancyStatus      = LOCeventDetails[20]
                        LOCcurrentLane          = LOCeventDetails[21]
                      )
                    )
                  )
                  else
                  (
                    local LOCbitArray = #{}; LOCbitArray.count = LOCveh[13]
                    for iii = 1 to LOCveh[13] by DDDYNstepInc.selection do LOCbitArray[iii] = true
                    LOCbitArray[LOCveh[13]] = true

                    for iii = 1 to LOCbitArray.count do
                    (
                      local LOCeventDetails = DSIMFUNreadElemQParVehicleEvent2D LOCfileStream

                      if (LOCbitArray[iii] == true) and LOCeventDetails[1] >= SPDYNstartTime.value and LOCeventDetails[1] <= SPDYNendTime.value then -- Check that we are within range of global start/end time
                      (
                        --- Create New 3ds Max Key Frame
                        local LOCframe    = ((LOCeventDetails[1] * frameRate) / SPDYNspeedMultiplier.value) + ((SPDYNshiftTime.value * frameRate) / SPDYNspeedMultiplier.value)

                        local LOCnewKeyP  = addNewKey LOCctrlPkeys  (LOCframe)
                        local LOCnewKeyR  = addNewKey LOCctrlRkeys  (LOCframe)
                        local LOCnewKeySe = addNewKey LOCctrlSeKeys (LOCframe)

                        LOCnewKeyP.value  = [LOCactualShiftX, LOCactualShiftY, SPDYNshiftZ.value] + [LOCeventDetails[3], LOCeventDetails[4], 0.0]
                        LOCnewKeyR.value  = (eulerAngles 0.0 0.0 (LOCeventDetails[2] - 180.0)) as quat
                        LOCnewKeySe.value = (LOCeventDetails[2] - 180.0)

                        --- Check Status of Extended Values Compared to Last KeyFrame
                        if LOCcurrentSpeed         != LOCeventDetails[05] then (local LOCnewKey = addNewKey LOCctrlCuSpkeys (LOCframe); LOCnewKey.value = LOCeventDetails[05])
                        if LOCisBrakingStatus      != LOCeventDetails[06] then (local LOCnewKey = addNewKey LOCctrlisBrkeys (LOCframe); LOCnewKey.selected = if LOCeventDetails[06] == 1 then true else false)
                        if LOCleftIndicatorStatus  != LOCeventDetails[07] then (local LOCnewKey = addNewKey LOCctrlIndLkeys (LOCframe); LOCnewKey.selected = if LOCeventDetails[07] == 1 then true else false)
                        if LOCrightIndicatorStatus != LOCeventDetails[08] then (local LOCnewKey = addNewKey LOCctrlIndRkeys (LOCframe); LOCnewKey.selected = if LOCeventDetails[08] == 1 then true else false)
                        if LOCisAcceleratingStatus != LOCeventDetails[09] then (local LOCnewKey = addNewKey LOCctrlisAckeys (LOCframe); LOCnewKey.selected = if LOCeventDetails[09] == 1 then true else false)
                        if LOCisStoppedStatus      != LOCeventDetails[10] then (local LOCnewKey = addNewKey LOCctrlisStkeys (LOCframe); LOCnewKey.selected = if LOCeventDetails[10] == 1 then true else false)

                        -- if LOCeventDetails[10]     == 1                   then print ("Vehicle is stopped at " + ((LOCeventDetails[1] as float) as string) + "s.")
                        -- if LOCinConjestionStatus   != LOCeventDetails[11] then print ("Conjestion Status Changed at " + ((LOCeventDetails[1] as float) as string) + "s.")
                        -- if LOCinAccidentStatus     != LOCeventDetails[12] then print ("Accident Status Changed at " + ((LOCeventDetails[1] as float) as string) + "s.")
                        -- if LOCcurrentLink          != LOCeventDetails[17] then print ("Link Status Changed at " + ((LOCeventDetails[1] as float) as string) + "s.")
                        -- if LOCoccupancyStatus      != LOCeventDetails[18] then print ("Occupancy Status Changed at " + ((LOCeventDetails[1] as float) as string) + "s.")
                        -- if LOCcurrentLane          != LOCeventDetails[19] then print ("Lane Status Changed at " + ((LOCeventDetails[1] as float) as string) + "s.")

                        LOCcurrentSpeed         = LOCeventDetails[05]
                        LOCisBrakingStatus      = LOCeventDetails[06]
                        LOCleftIndicatorStatus  = LOCeventDetails[07]
                        LOCrightIndicatorStatus = LOCeventDetails[08]
                        LOCisAcceleratingStatus = LOCeventDetails[09]
                        LOCisStoppedStatus      = LOCeventDetails[10]
                        LOCinConjestionStatus   = LOCeventDetails[11]
                        LOCinAccidentStatus     = LOCeventDetails[12]
                        LOCcurrentLink          = LOCeventDetails[17]
                        LOCoccupancyStatus      = LOCeventDetails[18]
                        LOCcurrentLane          = LOCeventDetails[19]
                      )
                    )
                  )

                  --- Add AppData for Vehicle (matches standard vehicle appData except 424)
                  local LOCappData425 = (DYNFUNgetLocalTime()) + "|" + LOCsimFile + "|" + (LOCveh[1] as string) + "|" + (LOCcurVehicleTypeDetails[2] as string)
                  DYNFUNgenObjAppData LOCobj 1 0 "" LOCappData425 "0" "0" DYNINIshadowSaver -- Add AppData to Vehicle
                  setAppData LOCobj 421 "DSIM"  -- for DSIM vehicles, reset 421 from "Dynamite" to "DSIM"
                  LOCobj.name = uniqueName (DYNuiResourcesNodeNames[3] + (LOCcurVehicleTypeDetails[2] as string) + "-")

                  --- Get Trailer Events
                  local LOCcurTrailerCount = readByte LOCfileStream
                  if LOCcurTrailerCount > 0 then  -- only enter this if more than one trailer exists
                  (
                    for iii = 1 to LOCcurTrailerCount do
                    (
                      local LOCtrailerID     = readByte LOCfileStream  -- Trailer ID
                      local LOCtrailerColorR = readByte LOCfileStream  -- Color Red
                      local LOCtrailerColorG = readByte LOCfileStream  -- Color Green
                      local LOCtrailerColorB = readByte LOCfileStream  -- Color Blue
                      local LOCtrailerWidth  = readFloat LOCfileStream -- Width
                      local LOCtrailerLength = readFloat LOCfileStream -- Length
                      local LOCtrailerHeight = readFloat LOCfileStream -- Height
                      local LOCtrailerWeight = readFloat LOCfileStream -- Weight
                      local LOCtrailerEvents = readLong LOCfileStream  -- Number of trailer events

                      local LOCtrailer = DYNFUNcreateVehicleDummy LOCtrailerWidth LOCtrailerLength LOCtrailerHeight (color LOCtrailerColorR LOCtrailerColorG LOCtrailerColorB)

                      --- Create Position/Rotation/Scale Controllers
                      local LOCtrailCtrlP         = LOCtrailer.pos.controller      = bezier_position()
                      local LOCtrailCtrlPkeys     = LOCtrailCtrlP.keys

                      local LOCtrailCtrlR         = LOCtrailer.rotation.controller = bezier_rotation()
                      local LOCtrailCtrlRkeys     = LOCtrailCtrlR.keys

                      local LOCtrailCtrlS         = LOCtrailer.scale.controller    = Civil_View_Traffic_Data_Constraint() -- Create Dummy Scale Controller to hold basic z rotation values (used later for culumative surface tracking), and extended parameters

                      local LOCtrailCtrlSe        = LOCtrailer.scale.controller.float03.controller = bezier_float() -- Rotation Z Saved Value
                      local LOCtrailCtrlSeKeys    = LOCtrailCtrlSe.keys

                      if DYNqparImport.LOCis3dFile then
                      (
                        local LOCbitArray = #{}; LOCbitArray.count = LOCtrailerEvents
                        for iiii = 1 to LOCtrailerEvents by DDDYNstepInc.selection do LOCbitArray[iiii] = true
                        LOCbitArray[LOCtrailerEvents] = true

                        for iiii = 1 to LOCbitArray.count do
                        (

                          --- Read and Apply Next Event
                          local LOCtStamp    = readFloat LOCfileStream -- TimeStamp
                          local LOCbearing   = readFloat LOCfileStream -- Bearing
                          local LOCx         = readFloat LOCfileStream -- X
                          local LOCy         = readFloat LOCfileStream -- Y
                          local LOCz         = readFloat LOCfileStream -- Z
                          local LOCgradient  = readFloat LOCfileStream -- Gradient

                          if (LOCbitArray[iiii] == true) and LOCtStamp >= SPDYNstartTime.value and LOCtStamp <= SPDYNendTime.value then -- Check that we are within range of global start/end time
                          (
                            --- Create New 3ds Max Key Frame
                            local LOCframe    = ((LOCtStamp * frameRate) / SPDYNspeedMultiplier.value) + ((SPDYNshiftTime.value * frameRate) / SPDYNspeedMultiplier.value)
                            local LOCnewKeyP  = addNewKey LOCtrailCtrlPkeys  (LOCframe)
                            local LOCnewKeyR  = addNewKey LOCtrailCtrlRkeys  (LOCframe)
                            local LOCnewKeySe = addNewKey LOCtrailCtrlSeKeys (LOCframe)

                            --- Insert KeyFrame Values
                            LOCnewKeyP.value      = [LOCactualShiftX, LOCactualShiftY, SPDYNshiftZ.value] + [LOCx, LOCy, LOCz]
                            LOCnewKeyR.value      = (eulerAngles 0.0 0.0 (LOCbearing - 180.0)) as quat
                            LOCnewKeySe.value     = (LOCbearing - 180.0)
                          )
                        )
                      )
                      else
                      (
                        local LOCbitArray = #{}; LOCbitArray.count = LOCtrailerEvents
                        for iiii = 1 to LOCtrailerEvents by DDDYNstepInc.selection do LOCbitArray[iiii] = true
                        LOCbitArray[LOCtrailerEvents] = true

                        for iiii = 1 to LOCbitArray.count do
                        (
                          --- Read and Apply Next Event
                          local LOCtStamp    = readFloat LOCfileStream -- TimeStamp
                          local LOCbearing   = readFloat LOCfileStream -- Bearing
                          local LOCx         = readFloat LOCfileStream -- X
                          local LOCy         = readFloat LOCfileStream -- Y

                          if (LOCbitArray[iiii] == true) and LOCtStamp >= SPDYNstartTime.value and LOCtStamp <= SPDYNendTime.value then -- Check that we are within range of global start/end time
                          (
                            --- Create New 3ds Max Key Frame
                            local LOCframe    = ((LOCtStamp * frameRate) / SPDYNspeedMultiplier.value) + ((SPDYNshiftTime.value * frameRate) / SPDYNspeedMultiplier.value)
                            local LOCnewKeyP  = addNewKey LOCtrailCtrlPkeys  (LOCframe)
                            local LOCnewKeyR  = addNewKey LOCtrailCtrlRkeys  (LOCframe)
                            local LOCnewKeySe = addNewKey LOCtrailCtrlSeKeys (LOCframe)

                            --- Insert KeyFrame Values
                            LOCnewKeyP.value      = [LOCactualShiftX, LOCactualShiftY, SPDYNshiftZ.value] + [LOCx, LOCy, 0.0]
                            LOCnewKeyR.value      = (eulerAngles 0.0 0.0 (LOCbearing - 180.0)) as quat
                            LOCnewKeySe.value     = (LOCbearing - 180.0)
                          )
                        )
                      )
                      local LOCappData425 = (DYNFUNgetLocalTime()) + "|" + LOCsimFile + "|" + (LOCveh[1] as string) + "|" + (LOCcurVehicleTypeDetails[2] as string)
                      DYNFUNgenObjAppData LOCtrailer 1 0 "" LOCappData425 "0" "0" DYNINIshadowSaver
                      setAppData LOCtrailer 421 "DSIM"  -- for DSIM vehicles, reset 421 from "Dynamite" to "DSIM"
                      LOCtrailer.name = LOCobj.name + " [" + DYNuiResourcesNodeNames[11] + " " + (LOCtrailerID as string) + "]"
                    )
                  )

                  --- CLOSE filestream
                  fClose LOCfileStream
                )
              )
              rootNode.DYNrootNodeStore.string04 = LOCsimFile
            )

            local LOCen = timestamp()
            LBDYNstatus.text = DYNuiResourcesStatusMessages[31] + " (" + (((LOCen - LOCst) / 1000.0) as string) + DYNuiResourcesUnitsTime[2] + ")"

            sleep 1

            dnProgress.value = 0

            destroyDialog DYNqparImport
            if LOCobjectsAlreadyExist == false then (max tool zoomextents all; max tool zoomextents all)
          )
        )
        DYNFUNloadVSPnodeCallBacks true
        DYNFUNnodeCreatedCallback()
      )
      else
      (
        messagebox (DYNuiResourcesErrorsWarnings[53]) title:DYNuiResourcesTitlebars[2]
      )
    )
  )

  on BUDYNcanc pressed do
  (
    destroyDialog DYNqparImport
  )

  on BUDYNhelp pressed do DYNFUNopenHelp 13218 -- id_cv_traffic_import
)


